<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Haleon Order Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #30ea03 0%, #28b803 100%);
            padding: 20px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .header h1 {
            color: white;
            margin: 0;
            font-size: 24px;
        }
        .content {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 0 0 8px 8px;
        }
        .info-box {
            background: white;
            padding: 15px;
            margin: 15px 0;
            border-left: 4px solid #30ea03;
            border-radius: 4px;
        }
        .brand-section {
            margin: 15px 0;
        }
        .brand-name {
            font-weight: bold;
            color: #30ea03;
            font-size: 16px;
            margin-bottom: 8px;
            padding-bottom: 5px;
            border-bottom: 2px solid #30ea03;
        }
        .product-item {
            padding: 8px 0 8px 20px;
            color: #555;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 12px;
            color: #777;
        }
        .button {
            display: inline-block;
            padding: 12px 24px;
            background-color: #30ea03;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Haleon Product Order Confirmation</h1>
    </div>

    <div class="content">
        <p>Your Haleon product order has been received and is being processed.</p>

        <div class="info-box">
            <strong>Order Details:</strong><br>
            <strong>Order ID:</strong> #{{ $order->id }}<br>
            <strong>Pharmacy:</strong> {{ $pharmacy }}<br>
            <strong>Date:</strong> {{ $order->created_at->format('F d, Y \a\t h:i A') }}<br>
            <strong>Total Items:</strong> {{ $totalItems }}
        </div>

        <h3>Order Summary:</h3>

        @foreach($itemsByBrand as $brandName => $brandItems)
            <div class="brand-section">
                <div class="brand-name">{{ $brandName }}</div>
                @foreach($brandItems as $item)
                    @php
                        $details = $item->getProductDetails();
                    @endphp
                    <div class="product-item">
                        • {{ $details['name'] }} ({{ $details['size'] }}) × {{ $item->quantity }}
                    </div>
                @endforeach
            </div>
        @endforeach

        <div style="margin-top: 20px;">
            <p><strong>A detailed PDF order form is attached to this email.</strong></p>
        </div>

        @if($order->notes)
            <div class="info-box">
                <strong>Notes:</strong><br>
                {{ $order->notes }}
            </div>
        @endif

        <p style="margin-top: 20px;">
            Thank you for your order! If you have any questions, please contact our support team.
        </p>
    </div>

    <div class="footer">
        <p>Generated by Haleon Orders System</p>
        <p style="font-size: 10px;">This is an automated email. Please do not reply to this message.</p>
    </div>
</body>
</html>
