<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PharmacyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'company_id' => $this->company_id,
            'pharmacy_name' => $this->pharmacy_name,
            'registration_number' => $this->registration_number,
            'contact_person' => $this->contact_person,
            'phone' => $this->phone,
            'email' => $this->email,
            'physical_address' => $this->physical_address,
            'delivery_address' => $this->delivery_address,
            'status' => $this->status,
            'created_by_rep_id' => $this->created_by_rep_id,
            'created_by_rep' => $this->whenLoaded('createdByRep', function () {
                return [
                    'id' => $this->createdByRep->id,
                    'name' => $this->createdByRep->name,
                    'email' => $this->createdByRep->email,
                ];
            }),
            'wholesaler_accounts' => PharmacyWholesalerAccountResource::collection($this->whenLoaded('wholesalers')),
            'created_at' => $this->created_at?->toISOString(),
            'updated_at' => $this->updated_at?->toISOString(),
        ];
    }
}
