<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'pharmacy_name' => $this->pharmacy_name,
            'email' => $this->email,
            'total_items' => $this->total_items,
            'status' => $this->status,
            'notes' => $this->notes,
            'processed_at' => $this->processed_at?->toISOString(),
            'items' => OrderItemResource::collection($this->whenLoaded('items')),
            'pdf' => new OrderPdfResource($this->whenLoaded('pdf')),
            'created_at' => $this->created_at?->toISOString(),
            'updated_at' => $this->updated_at?->toISOString(),
        ];
    }
}
